// FileMapper.cpp: implementation of the CFileMapper class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "FileMapper.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFileMapper::CFileMapper(LPCTSTR Filename)
{
FileMapping = FileHandle = INVALID_HANDLE_VALUE;
View = NULL;
FileSize = 0;
CreateFileMapping (Filename);
}

CFileMapper::CFileMapper()
{
FileMapping = FileHandle = INVALID_HANDLE_VALUE;
View = NULL;
FileSize = 0;
}

CFileMapper::~CFileMapper()
{
CloseFileMapping();
}

bool CFileMapper::CreateFileMapping(LPCTSTR Filename)
{
FileHandle = CreateFile (Filename,
						GENERIC_READ/* | GENERIC_WRITE*/,
						FILE_SHARE_READ,
						NULL,
						OPEN_EXISTING,
						FILE_ATTRIBUTE_NORMAL,
						NULL);
if (FileHandle == INVALID_HANDLE_VALUE)
	{
	return (false);
    };
FileSize = GetFileSize (FileHandle, NULL);
FileMapping = ::CreateFileMapping (FileHandle,
                                   NULL,
                                   PAGE_READONLY,
                                   0,
                                   FileSize,
                                   NULL);
if (FileMapping == INVALID_HANDLE_VALUE)
	{
    CloseFileMapping();
    return (false);
    };
View = MapViewOfFile (FileMapping,
                      FILE_MAP_READ, //FILE_MAP_ALL_ACCESS,
                      0,
                      0,
                      0);
if (View == NULL)
    {
    CloseFileMapping();
    return (false);
    };
return (true);
}

bool CFileMapper::CreateFileMapping(LPCTSTR Filename, DWORD From, DWORD Length)
{
bool Result = CreateFileMapping (Filename);
if (Result)
    {
    View = &(((BYTE *) View) [From]);
    };
return (Result);
}

void CFileMapper::CloseFileMapping()
{
UnmapViewOfFile(View);
CloseHandle (FileMapping);
CloseHandle (FileHandle);
FileMapping = FileHandle = INVALID_HANDLE_VALUE;
View = NULL;
FileSize = 0;
}

CFileMapper::operator LPTSTR()
{
return (LPTSTR (View));
}

DWORD CFileMapper::GetSize()
{
return (FileSize);
}

LPVOID CFileMapper::GetView()
{
return (View);
}

bool CFileMapper::Open(LPCTSTR Filename)
{
Close();
return (CreateFileMapping (Filename));
}

void CFileMapper::Close()
{
CloseFileMapping();
}
