// HtmlExpert.cpp: implementation of the CHtmlExpert class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HTML Rebuilder.h"
#include "HtmlExpert.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CHtmlExpert::CHtmlExpert()
{

}

CHtmlExpert::~CHtmlExpert()
{

}

bool CHtmlExpert::Rebuild(LPCTSTR Filename)
{
bool Result = CHtmlTreeBuilder::Parse(Filename);
if (!Result)
    {
    ::DeleteFile (CHtmlRebuilder::GetTargetFilename(Filename));
    }
else
    {
    RearrangeTree(Filename);
    };
return (Result);
}


void CHtmlExpert::RearrangeTree(LPCTSTR Filename)
{
CFile Target (CHtmlRebuilder::GetTargetFilename(Filename), CFile::modeWrite | CFile::modeCreate);
CHtmlNode::Write (Target, _T("<html><body>"));

CHtmlNode *Body = m_MainNode.Search (_T("html"))->Search(_T("body"));
for (int TableIndex = 0;;)
    {
    CHtmlNode *Table = Body->Search (_T("table"), TableIndex, &TableIndex);
    if (!Table)
        {
        break;
        };
    if ((Table->GetAttribute (_T("cols")).CompareNoCase(_T("1")) == 0)
        && (Table->GetAttribute (_T("cellpadding")).CompareNoCase(_T("5")) == 0)
        && (!Table->GetAttribute (_T("bgcolor")).IsEmpty()))
        {
        CString Content = Table->GetFullContent();
        CHtmlNode::FullTrim(Content);
        CHtmlNode::Write (Target, _T("<h1>"));
        CHtmlNode::Write (Target, Content);
        CHtmlNode::Write (Target, _T("</h1>"));
        if (Content.Find ("ervenec") >= 0)
            {
            int x = 9;
            };
        Table = Body->Search (_T("table"), TableIndex, &TableIndex);
        for (int RowIndex = 0;;)
            {
            CHtmlNode *Row = Table->Search (_T("tr"), RowIndex, &RowIndex);
            if (!Row)
                {
                break;
                };
            switch (Row->CountOf (_T("td")))
                {
                case 1 :
                    {
                    CHtmlNode *Cell = Row->Search (_T("td"));
                    Cell->WriteNodes(Target);
                    break;
                    };
                    
                case 3 :
                    {
                    int CellIndex = 0;
                    CHtmlNode *DateCell = Row->Search (_T("td"), CellIndex, &CellIndex);
                    CHtmlNode *ContentCell = Row->Search (_T("td"), CellIndex, &CellIndex);
                    ContentCell = Row->Search (_T("td"), CellIndex, &CellIndex);
                    CString DateContent = DateCell->GetFullContent();
                    CHtmlNode::FullTrim(DateContent);
                    CHtmlNode::Write (Target, _T("<h2>"));
                    CHtmlNode::Write (Target, DateContent);
                    CHtmlNode::Write (Target, _T("</h2>"));
                    ContentCell->WriteNodes (Target);
                    break;
                    };
                    
                default :
                    {
                    break;
                    };
                };
            };
        };
    };

CHtmlNode::Write (Target, _T("</body></html>"));
}

void CHtmlExpert::FillTree(CTreeCtrl *TreeCtrl)
{
ASSERT (TreeCtrl);
VERIFY (TreeCtrl->DeleteAllItems());
m_MainNode.AddToTree (TreeCtrl, TVI_ROOT);
}
