// HtmlNode.h: interface for the CHtmlNode class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HTMLNODE_H__85BB86B1_7AA4_441E_A0DB_98F5C752D5C5__INCLUDED_)
#define AFX_HTMLNODE_H__85BB86B1_7AA4_441E_A0DB_98F5C752D5C5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxtempl.h>

enum EHtmlNodeType
    {
    TAG,
    CONTENT,
    SPECIAL
    };

class CHtmlNode  
{
public:
	void AddToTree (CTreeCtrl *TreeCtrl, HTREEITEM HParent);
	void WriteNodes (CFile &Target);
    static void FullTrim (CString &String);
    static void DeNbsp (CString &String);
    static void Write (CFile &File, LPCTSTR String);

    int CountOf (LPCTSTR TagName);
	CString GetFullContent();
	CString GetAttribute (LPCTSTR AttrName);
	bool GetAttribute (LPCTSTR AttrName, CString &AttrValue);
	CHtmlNode* Search (LPCTSTR TagName, int FromIndex = -1, int *Position = NULL);
	int GetSize();
    CHtmlNode* operator [] (int Index);
    
    void Write (CFile &Target);
	void AddSpecialTag (LPCTSTR Content);
	void DeleteAll();
	void AddContents (LPCTSTR Contents);
	void AddAttribute (LPCTSTR Name, LPCTSTR Value);
	CHtmlNode* AddTag (LPCTSTR NodeName);
	CHtmlNode* Close (LPCTSTR NodeName);
	CHtmlNode* Add (CHtmlNode *Node);
	CString GetName();

    CHtmlNode(LPCTSTR Name = NULL, EHtmlNodeType Type = TAG);
	virtual ~CHtmlNode();

protected:

    bool                              m_Closed;
    CHtmlNode                        *m_SuperNode;
    CArray <CHtmlNode *, CHtmlNode *> m_Nodes;
    CStringArray                      m_Attributes;
    CString                           m_Name;
    EHtmlNodeType                     m_Type;
};

#endif // !defined(AFX_HTMLNODE_H__85BB86B1_7AA4_441E_A0DB_98F5C752D5C5__INCLUDED_)
