// HtmlParser.h: interface for the CHtmlParser class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HTMLPARSER_H__CB5473BB_0346_42FC_A708_15491E616DB7__INCLUDED_)
#define AFX_HTMLPARSER_H__CB5473BB_0346_42FC_A708_15491E616DB7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "FileMapper.h"

class CHtmlParser  
{
public:
	virtual void OnSpecialTag (LPCTSTR Tag, int TagLength);
	virtual void OnContents (LPCTSTR Contents, int ContentsLength);
	virtual void OnTagClose(LPCTSTR TagName, int TagNameLength, bool Ends);
	virtual void OnAttribute (LPCTSTR Name, int NameLength, LPCTSTR Value, int ValueLength);
	virtual void OnTag (LPCTSTR TagName, int TagNameLength);
	virtual void OnClosingTag (LPCTSTR TagName, int TagNameLength);

	void Close();
	bool Parse();
	bool Open (LPCTSTR Filename);

    CHtmlParser();
	virtual ~CHtmlParser();

protected:
    bool ParseAttribute (LPCTSTR *AttributeName, int &AttributeNameLength, LPCTSTR *AttributeValue, int &AttributeValueLength, bool &Error);
    bool Search (LPCTSTR String);
    bool SearchForEndingTag (LPCTSTR TagName, int TagNameLength);
    bool ParseIdentifier(LPCTSTR *Identifier, int &Count);
	void SkipWhitespace();
	bool Search (TCHAR Char);
    
    LPCTSTR     m_Position;
    CString     m_Source;
    CString     m_SourceFilename;
};

#endif // !defined(AFX_HTMLPARSER_H__CB5473BB_0346_42FC_A708_15491E616DB7__INCLUDED_)
