// HtmlRebuilder.h: interface for the CHtmlRebuilder class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HTMLREBUILDER_H__304CED43_80D9_4D05_8EE1_CE470F939DB4__INCLUDED_)
#define AFX_HTMLREBUILDER_H__304CED43_80D9_4D05_8EE1_CE470F939DB4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "HtmlParser.h"

class CHtmlRebuilder : protected CHtmlParser  
{
public:
	static CString GetTargetFilename (LPCTSTR Filename);
	virtual bool Rebuild (LPCTSTR Filename);
	CHtmlRebuilder();
	virtual ~CHtmlRebuilder();

protected:
    virtual void OnSpecialTag (LPCTSTR Tag, int TagLength);
    virtual void OnContents (LPCTSTR Contents, int ContentsLength);
    virtual void OnTagClose(LPCTSTR TagName, int TagNameLength, bool Ends);
    virtual void OnAttribute (LPCTSTR Name, int NameLength, LPCTSTR Value, int ValueLength);
    virtual void OnTag (LPCTSTR TagName, int TagNameLength);
    virtual void OnClosingTag (LPCTSTR TagName, int TagNameLength);

    void Write (LPCTSTR String);
    void Write (LPCTSTR String, int CharCount);
	void OpenTarget (LPCTSTR Filename);
    CFile   m_Target;
    CString m_TargetFilename;
};

#endif // !defined(AFX_HTMLREBUILDER_H__304CED43_80D9_4D05_8EE1_CE470F939DB4__INCLUDED_)
