// HtmlTreeBuilder.cpp: implementation of the CHtmlTreeBuilder class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HTML Rebuilder.h"
#include "HtmlTreeBuilder.h"
#include "HtmlRebuilder.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CHtmlTreeBuilder::CHtmlTreeBuilder()
{

}

CHtmlTreeBuilder::~CHtmlTreeBuilder()
{

}

bool CHtmlTreeBuilder::Parse(LPCTSTR Filename)
{
m_MainNode.DeleteAll();
m_CurrentNode = &m_MainNode;
bool Result = (Open(Filename) && CHtmlParser::Parse());
return (Result);
}

void CHtmlTreeBuilder::OnClosingTag(LPCTSTR TagName, int TagNameLength)
{
m_CurrentNode = m_CurrentNode->Close (CString (TagName, TagNameLength));
}

void CHtmlTreeBuilder::OnTag(LPCTSTR TagName, int TagNameLength)
{
m_CurrentNode = m_CurrentNode->AddTag (CString (TagName, TagNameLength));
}

void CHtmlTreeBuilder::OnAttribute(LPCTSTR Name, int NameLength, LPCTSTR Value, int ValueLength)
{
m_CurrentNode->AddAttribute (CString (Name, NameLength), CString (Value, ValueLength));
}

void CHtmlTreeBuilder::OnTagClose(LPCTSTR TagName, int TagNameLength, bool Ends)
{
if (Ends)
    {
    m_CurrentNode = m_CurrentNode->Close (CString (TagName, TagNameLength));
    };
}

void CHtmlTreeBuilder::OnContents(LPCTSTR Contents, int ContentsLength)
{
m_CurrentNode->AddContents(CString (Contents, ContentsLength));
}

void CHtmlTreeBuilder::OnSpecialTag(LPCTSTR Tag, int TagLength)
{
m_CurrentNode->AddSpecialTag (CString (Tag, TagLength));
}
