// HtmlTreeBuilder.h: interface for the CHtmlTreeBuilder class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_HTMLTREEBUILDER_H__2791288B_A91C_4C29_85EF_CD5665D4C248__INCLUDED_)
#define AFX_HTMLTREEBUILDER_H__2791288B_A91C_4C29_85EF_CD5665D4C248__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "HtmlParser.h"
#include "HtmlNode.h"

    class CHtmlTreeBuilder : protected CHtmlParser  
{
public:
	virtual bool Parse (LPCTSTR Filename);

	CHtmlTreeBuilder();
	virtual ~CHtmlTreeBuilder();

protected:
    virtual void OnSpecialTag (LPCTSTR Tag, int TagLength);
    virtual void OnContents (LPCTSTR Contents, int ContentsLength);
    virtual void OnTagClose(LPCTSTR TagName, int TagNameLength, bool Ends);
    virtual void OnAttribute (LPCTSTR Name, int NameLength, LPCTSTR Value, int ValueLength);
    virtual void OnTag (LPCTSTR TagName, int TagNameLength);
    virtual void OnClosingTag (LPCTSTR TagName, int TagNameLength);

    CHtmlNode *m_CurrentNode;
    CHtmlNode  m_MainNode;
};

#endif // !defined(AFX_HTMLTREEBUILDER_H__2791288B_A91C_4C29_85EF_CD5665D4C248__INCLUDED_)
