// HtmlNode.cpp: implementation of the CHtmlNode class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HTML Rebuilder.h"
#include "HtmlNode.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CHtmlNode::CHtmlNode(LPCTSTR Name, EHtmlNodeType Type)
: m_Name (Name)
{
m_Type = Type;
m_SuperNode = NULL;
m_Closed = false;
}

CHtmlNode::~CHtmlNode()
{
DeleteAll();
}

CString CHtmlNode::GetName()
{
return (m_Name);
}

CHtmlNode* CHtmlNode::Add(CHtmlNode *Node)
{
ASSERT (!Node->m_SuperNode);
Node->m_SuperNode = this;
m_Nodes.Add (Node);
return (Node);
}

CHtmlNode* CHtmlNode::Close(LPCTSTR NodeName)
{
if (m_Name.CompareNoCase(NodeName) == 0)
    {
    m_Closed = true;
    return (m_SuperNode);
    };
ASSERT (m_SuperNode);
int Count = m_Nodes.GetSize();
for (int Index = 0; Index < Count; Index++)
    {
    CHtmlNode *CurrNode = m_Nodes [Index];
    CurrNode->m_SuperNode = NULL;
    m_SuperNode->Add (CurrNode);
    };
m_Nodes.SetSize (0);
return (m_SuperNode->Close (NodeName));
}

CHtmlNode* CHtmlNode::AddTag(LPCTSTR NodeName)
{
return (Add (new CHtmlNode (NodeName, TAG)));
}

void CHtmlNode::AddAttribute(LPCTSTR Name, LPCTSTR Value)
{
m_Attributes.Add (Name);
m_Attributes.Add (Value);
}

void CHtmlNode::AddContents(LPCTSTR Contents)
{
CHtmlNode *ContentsNode = new CHtmlNode (Contents, CONTENT);
Add (ContentsNode);
}

void CHtmlNode::DeleteAll()
{
int Count = m_Nodes.GetSize();
for (int Index = 0; Index < Count; Index++)
    {
    delete m_Nodes [Index];
    };
m_Nodes.SetSize (0);
}

void CHtmlNode::AddSpecialTag(LPCTSTR Content)
{
CHtmlNode *Node = new CHtmlNode (Content, SPECIAL);
Add (Node);
}

void CHtmlNode::Write(CFile &Target)
{
switch (m_Type)
    {
    case TAG :
        {
        if (m_Name.IsEmpty())
            {
            WriteNodes (Target);
            }
        else
            {
            Write (Target, _T("<"));
            Write (Target, m_Name);
            int Count = m_Attributes.GetSize();
            for (int Index = 0; Index < Count; Index++)
                {
                Write (Target, _T(" "));
                Write (Target, m_Attributes [Index]);
                Index++;
                if (!m_Attributes [Index].IsEmpty())
                    {
                    Write (Target, _T("=\""));
                    Write (Target, m_Attributes [Index]);
                    Write (Target, _T("\""));
                    };
                };
            Count = m_Nodes.GetSize();
            if (!Count && !m_Closed)
                {
                Write (Target, _T("/>"));
                }
            else
                {
                Write (Target, _T(">"));
                for (int Index = 0; Index < Count; Index++)
                    {
                    m_Nodes [Index]->Write(Target);
                    };
                Write (Target, _T("</"));
                Write (Target, m_Name);
                Write (Target, _T(">"));
                };
            }
        break;
        };
    
    case CONTENT :
        {
        Write (Target, m_Name);
        break;
        };

    case SPECIAL :
        {
        Write (Target, _T("<"));
        Write (Target, m_Name);
        Write (Target, _T(">"));
        break;
        };
    };
}

void CHtmlNode::Write(CFile &File, LPCTSTR String)
{
File.Write(String, _tcslen (String));
}

CHtmlNode* CHtmlNode::operator [] (int Index)
{
return (m_Nodes [Index]);
}

int CHtmlNode::GetSize()
{
return (m_Nodes.GetSize());
}

CHtmlNode* CHtmlNode::Search(LPCTSTR TagName, int FromIndex, int *Position)
{
int Count = m_Nodes.GetSize();
FromIndex++;
FromIndex = min (FromIndex, Count);
for (int Index = FromIndex; Index < Count; Index++)
    {
    CHtmlNode *CurrNode = m_Nodes [Index];
    if ((CurrNode->m_Type == TAG) && (CurrNode->m_Name.CompareNoCase(TagName) == 0))
        {
        if (Position)
            {
            *Position = Index;
            };
        return (CurrNode);
        };
    };
return (NULL);
}

bool CHtmlNode::GetAttribute(LPCTSTR AttrName, CString &AttrValue)
{
if (m_Type == TAG)
    {
    int Count = m_Attributes.GetSize();
    for (int Index = 0; Index < Count; Index += 2)
        {
        if (m_Attributes [Index].CompareNoCase(AttrName) == 0)
            {
            AttrValue = m_Attributes [Index + 1];
            return (true);
            };
        };
    };
return (false);
}

CString CHtmlNode::GetAttribute(LPCTSTR AttrName)
{
CString AttrValue;
GetAttribute (AttrName, AttrValue);
return (AttrValue);
}

CString CHtmlNode::GetFullContent()
{
CString Result;
switch (m_Type)
    {    
    case TAG :
        {
        int Count = m_Nodes.GetSize();
        for (int Index = 0; Index < Count; Index ++)
            {
            Result += m_Nodes [Index]->GetFullContent();
            };
        break;
        };

    case CONTENT :
        {
        Result = m_Name;
        break;
        };
    };
return (Result);
}

int CHtmlNode::CountOf(LPCTSTR TagName)
{
int Result = 0;
int Count = m_Nodes.GetSize();
for (int Index = 0; Index < Count; Index++)
    {
    CHtmlNode *CurrNode = m_Nodes [Index];
    if ((CurrNode->m_Type == TAG) && (CurrNode->m_Name.CompareNoCase(TagName) == 0))
        {
        Result++;
        };
    };
return (Result);
}

void CHtmlNode::DeNbsp(CString &String)
{
for (int NbspIndex = String.Find (_T("&nbsp;"));
     NbspIndex >= 0;
     NbspIndex = String.Find (_T("&nbsp;")))
     {
     String = String.Left (NbspIndex) + String.Mid (NbspIndex + 6);
     };
}

void CHtmlNode::FullTrim(CString &String)
{
DeNbsp (String);
String.TrimLeft();
String.TrimRight();
}

void CHtmlNode::WriteNodes(CFile &Target)
{
int Count = m_Nodes.GetSize();
for (int Index = 0; Index < Count; Index++)
    {
    m_Nodes [Index]->Write(Target);
    };
}

void CHtmlNode::AddToTree(CTreeCtrl *TreeCtrl, HTREEITEM HParent)
{
switch (m_Type)
    {
    case TAG :
        {
        if (m_Name.IsEmpty())
            {
            int Count = m_Nodes.GetSize();
            for (int Index = 0; Index < Count; Index++)
                {
                m_Nodes [Index]->AddToTree(TreeCtrl, HParent);
                };
            }
        else
            {
            CString Buffer (_T("<"));
            Buffer += m_Name;
            int Count = m_Attributes.GetSize();
            for (int Index = 0; Index < Count; Index++)
                {
                Buffer += _T(" ");
                Buffer += m_Attributes [Index];
                Index++;
                if (!m_Attributes [Index].IsEmpty())
                    {
                    Buffer += _T("=\"");
                    Buffer += m_Attributes [Index];
                    Buffer += _T("\"");
                    };
                };
            Buffer += _T(">");
            HTREEITEM HItem = TreeCtrl->InsertItem (Buffer, 0, 0, HParent);
            Count = m_Nodes.GetSize();
            for (Index = 0; Index < Count; Index++)
                {
                m_Nodes [Index]->AddToTree(TreeCtrl, HItem);
                };
            }
        break;
        };
        
    case CONTENT :
        {
        CString Buffer (m_Name);
        Buffer.TrimLeft();
        Buffer.TrimRight();
        if (!Buffer.IsEmpty())
            {
            TreeCtrl->InsertItem (Buffer, 0, 0, HParent);
            };
        break;
        };
        
    case SPECIAL :
        {
        CString Buffer (_T("<"));
        Buffer += m_Name;
        Buffer += _T(">");
        TreeCtrl->InsertItem (Buffer, 0, 0, HParent);
        break;
        };
    };
}
