// HtmlRebuilder.cpp: implementation of the CHtmlRebuilder class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "HTML Rebuilder.h"
#include "HtmlRebuilder.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CHtmlRebuilder::CHtmlRebuilder()
{

}

CHtmlRebuilder::~CHtmlRebuilder()
{

}

bool CHtmlRebuilder::Rebuild(LPCTSTR Filename)
{
if (Open (Filename))
    {
    OpenTarget (Filename);
    bool Result = Parse();
    m_Target.Close();
    if (!Result)
        {
        ::DeleteFile (m_TargetFilename);
        };
    return (Result);
    }
else
    {
    return (false);
    };
}

void CHtmlRebuilder::OpenTarget(LPCTSTR Filename)
{
m_TargetFilename = GetTargetFilename (Filename);
m_Target.Open (m_TargetFilename, CFile::modeCreate | CFile::modeWrite);
}

void CHtmlRebuilder::Write(LPCTSTR String, int CharCount)
{
m_Target.Write (String, CharCount * sizeof (TCHAR));
}

void CHtmlRebuilder::Write(LPCTSTR String)
{
Write (String, _tcslen (String));
}

void CHtmlRebuilder::OnClosingTag(LPCTSTR TagName, int TagNameLength)
{
Write (_T("</"));
Write (TagName, TagNameLength);
Write (_T(">"));
}

void CHtmlRebuilder::OnTag(LPCTSTR TagName, int TagNameLength)
{
Write (_T("<"));
Write (TagName, TagNameLength);
}

void CHtmlRebuilder::OnAttribute(LPCTSTR Name, int NameLength, LPCTSTR Value, int ValueLength)
{
Write (_T(" "));
Write (Name, NameLength);
if (Value && ValueLength)
    {
    Write (_T("=\""));
    Write (Value, ValueLength);
    Write (_T("\""));
    };
}

void CHtmlRebuilder::OnTagClose(LPCTSTR TagName, int TagNameLength, bool Ends)
{
if (Ends)
    {
    Write (_T("/>"));
    }
else
    {
    Write (_T(">"));
    };
}

void CHtmlRebuilder::OnContents(LPCTSTR Contents, int ContentsLength)
{
Write (Contents, ContentsLength);
}

void CHtmlRebuilder::OnSpecialTag(LPCTSTR Tag, int TagLength)
{
Write (_T("<"));
Write (Tag, TagLength);
Write (_T(">"));
}

CString CHtmlRebuilder::GetTargetFilename(LPCTSTR Filename)
{
char drive[_MAX_DRIVE];
char dir[_MAX_DIR];
char fname[_MAX_FNAME];
char ext[_MAX_EXT];
_splitpath (Filename, drive, dir, fname, ext);
CString TargetFilename = CString (drive) + dir + _T("_rebuilded\\");
CreateDirectory (TargetFilename, NULL);
TargetFilename += fname;
TargetFilename += ext;
return (TargetFilename);
}
