// Allocator.cpp: implementation of the CAllocator class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Allocator.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAllocator Allocator; // defaultn aloktor, nem smysl dlat jin

DWORD CMemBlock::GetSize()
{
return (m_Header & BF_SIZE_MASK);
}

DWORD& CMemBlock::PreviousBlockSizeAtEnd()
{
ASSERT (IsPreviousFree());
return (LPDWORD (this) [-1]);
}

DWORD& CMemBlock::BlockSizeAtEnd()
{
return (LPDWORD (&(LPBYTE (this) [GetSize()])) [-1]);
}

CMemBlock* CMemBlock::GetNext()
{
DWORD Size = GetSize();
if (Size)
    {
    return ((CMemBlock*) &(LPBYTE (this) [ROUND_SIZE (Size)]));
    }
else
    {
    return (NULL);
    };
}

bool CMemBlock::IsPreviousFree()
{
return ((m_Header & BF_PREVIOUS_IS_FREE) != 0);
}

void CMemBlock::SetSize(DWORD NewSize)
{
m_Header = (m_Header & BF_FLAGS_MASK) | NewSize;
}

void CMemBlock::BeFree(bool BeSuch)
{
ASSERT (IS_ROUNDED (this));
if (BeSuch)
    {
    ASSERT (IS_ROUNDED (GetSize()));
    m_Header |= BF_IS_FREE;
    GetNext()->m_Header |= BF_PREVIOUS_IS_FREE;
    BlockSizeAtEnd() = GetSize();
    }
else
    {
    m_Header &= ~BF_IS_FREE;
    GetNext()->m_Header &= ~BF_PREVIOUS_IS_FREE;
    };
}

bool CMemBlock::IsFree()
{
if ((m_Header & BF_IS_FREE) != 0)
    {
    ASSERT (GetNext()->m_Header & BF_PREVIOUS_IS_FREE);
    ASSERT (IS_ROUNDED (GetSize()));
    ASSERT (BlockSizeAtEnd() == GetSize());
    };
return ((m_Header & BF_IS_FREE) != 0);
}

bool CMemBlock::NotFree()
{
return (!IsFree());
}

CFreeMemBlock* CMemBlock::GetPrevBlock()
{
ASSERT (IsPreviousFree());
return ((CFreeMemBlock*) &(LPBYTE (this) [-int (PreviousBlockSizeAtEnd())]));
}

void CMemBlock::SetPreviousIsFree(bool IsSuch)
{
ASSERT (IS_ROUNDED (this));
if (IsSuch)
    {
    m_Header |= BF_PREVIOUS_IS_FREE;
    ASSERT (GetPrevBlock()->IsFree());
    }
else
    {
    m_Header &= ~BF_PREVIOUS_IS_FREE;
    };
}

CAllocator::CAllocator()
{
Create();
}

CAllocator::~CAllocator()
{
Destroy();
}

void CAllocator::Create()
{
ZeroMemory (this, sizeof (*this));
m_ReservedSize = INITIAL_RESERVED_SIZE;
m_Reserved = ::VirtualAlloc (NULL, m_ReservedSize, MEM_RESERVE, PAGE_EXECUTE_READWRITE);
ASSERT (m_Reserved);
m_CommitedSize = INITIAL_SIZE;
m_Main = (CFreeMemBlock*) ::VirtualAlloc (m_Reserved, m_CommitedSize, MEM_COMMIT, PAGE_EXECUTE_READWRITE);
ASSERT (m_Main == m_Reserved);
ASSERT (m_Main);
ASSERT (IS_ROUNDED (m_Main));
ZeroMemory (m_Main, m_CommitedSize);
m_Main->m_Header = (m_CommitedSize - GRANULARITY) | BF_IS_FREE;
CMemBlock *Last = m_Main->GetNext();
ASSERT (Last);
ASSERT (IS_ROUNDED (Last));
Last->m_Header = 0 | BF_PREVIOUS_IS_FREE;
Last->PreviousBlockSizeAtEnd() = INITIAL_SIZE - GRANULARITY;
m_Free [BIG_BLOCKS_FREE_LIST] = m_Main;
}

void CAllocator::Cut(CMemBlock *CuttedBlock, DWORD Size)
{
DWORD RoundedSize = ROUND_SIZE (Size);
DWORD CuttedBlockSize = CuttedBlock->GetSize();
ASSERT (IS_ROUNDED (CuttedBlockSize));
ASSERT (RoundedSize < CuttedBlockSize);
CuttedBlockSize -= RoundedSize;
CuttedBlock->SetSize (Size);
CuttedBlock->BeFree (false);
CFreeMemBlock *RestOfCuttedBlock = (CFreeMemBlock *) CuttedBlock->GetNext();
ASSERT (IS_ROUNDED (RestOfCuttedBlock));
ASSERT (IS_ROUNDED (CuttedBlockSize));
ASSERT (CuttedBlockSize);
RestOfCuttedBlock->SetSize (CuttedBlockSize);
RestOfCuttedBlock->BeFree (true);
LinkFreeBlock (RestOfCuttedBlock, CuttedBlockSize);
}

#ifdef _DEBUG
LPVOID CAllocator::Alloc(DWORD Size, DWORD Flags)
{
LPVOID Allocated = DoAlloc(Size, Flags);
if (Allocated && GetDataBlock (Allocated)->GetSize() != Size + sizeof (DWORD))
    {
    ASSERT (false);
    DWORD TrueSize = GetDataBlock (Allocated)->GetSize();
    Check();
    };
return (Allocated);
}


LPVOID CAllocator::DoAlloc(DWORD Size, DWORD Flags)
#else
LPVOID CAllocator::Alloc(DWORD Size, DWORD Flags)
#endif
{
Size += sizeof (DWORD);
DWORD FreeListIndex = (Size - 1) / GRANULARITY;
if (FreeListIndex < FREE_LISTS_COUNT)
    {
    CFreeMemBlock** FreeList = &m_Free [FreeListIndex];
    if (*FreeList)
        {
        CFreeMemBlock* Block = *FreeList;
        if ((*FreeList) = Block->m_NextFree)
            {
            (*FreeList)->m_PrevFree = NULL;
            };
        Block->BeFree (false);
        Block->SetSize (Size);
        ASSERT (Block->GetSize() == Size);
        return (GetBlockData (Block));
        };
    for (FreeList = &FreeList [1]; // next free list
         FreeList != &m_Free [BIG_BLOCKS_FREE_LIST];
         FreeList = &FreeList [1]) // next free list
        {
        if (*FreeList)
            {
            CFreeMemBlock* Block = *FreeList;
            if (*FreeList = Block->m_NextFree)
                {
                (*FreeList)->m_PrevFree = NULL;
                };
            Cut (Block, Size);
            CHECK_ALLOCATOR;
            ASSERT (Block->GetSize() == Size);
            return (GetBlockData (Block));
            };
        };
    };
// Try to allocate from big blocks
LPVOID Data = AllocFromBigBlocks(Size);
if (Data)
    {
    CHECK_ALLOCATOR;
    ASSERT (GetDataBlock (Data)->GetSize() == Size);
    return (Data);
    };
Data = CoalesceThenAlloc(Size);
if (Data || (Flags & AF_NO_GROW))
    {
    CHECK_ALLOCATOR;
    ASSERT (!Data || GetDataBlock (Data)->GetSize() == Size);
    return (Data);
    };
return (GrowThenAlloc(Size));
}

LPVOID CAllocator::GetBlockData(CMemBlock *Block)
{
ASSERT (!Block->IsFree());
return (&LPDWORD (Block) [1]);
}

void CAllocator::LinkFreeBlock(CFreeMemBlock *FreeBlock, DWORD BlockSize)
{
ASSERT (FreeBlock->IsFree());
CFreeMemBlock** FreeList = FreeListForSize (BlockSize);
FreeBlock->m_PrevFree = NULL;
if (FreeBlock->m_NextFree = (*FreeList))
    {
    (*FreeList)->m_PrevFree = FreeBlock;
    };
(*FreeList) = FreeBlock;
}

void CAllocator::Destroy()
{
VERIFY (::VirtualFree (m_Reserved, 0, MEM_RELEASE));
}

void CAllocator::Free(LPVOID Data)
{
CFreeMemBlock *Block = (CFreeMemBlock*) GetDataBlock (Data);
ASSERT (!Block->IsFree());
ASSERT (IS_ROUNDED (Block));
CFreeMemBlock** FreeList = FreeListForSize (Block->GetSize());
Block->SetSize (ROUND_SIZE (Block->GetSize()));
if (Block->m_NextFree = (*FreeList))
    {
    (*FreeList)->m_PrevFree = Block;
    };
((*FreeList) = Block)->m_PrevFree = NULL;
Block->BeFree(true);
CHECK_ALLOCATOR;
}

CMemBlock* CAllocator::GetDataBlock(LPVOID Data)
{
ASSERT (!((CMemBlock*) &LPDWORD (Data) [-1])->IsFree());
return ((CMemBlock*) &LPDWORD (Data) [-1]);
}

CFreeMemBlock** CAllocator::FreeListForSize(DWORD BlockSize)
{
DWORD Index = (BlockSize - 1) / GRANULARITY;
return (&m_Free [min (Index, FREE_LISTS_COUNT)]);
}

LPVOID CAllocator::AllocFromBigBlocks(DWORD Size)
{
DWORD RoundedSize = ROUND_SIZE (Size);
for (CFreeMemBlock* Block = m_Free [BIG_BLOCKS_FREE_LIST];
     Block;
     Block = Block->m_NextFree)
     {
     ASSERT (Block->IsFree());
     DWORD BlockSize = Block->GetSize();
     if (RoundedSize <= BlockSize)
         {
         if (Block->m_PrevFree)
             {
             Block->m_PrevFree->m_NextFree = Block->m_NextFree;
             }
         else
             {
             m_Free [BIG_BLOCKS_FREE_LIST] = Block->m_NextFree;
             };
         if (Block->m_NextFree)
             {
             Block->m_NextFree->m_PrevFree = Block->m_PrevFree;
             };
         CHECK_ALLOCATOR;
         if (RoundedSize < BlockSize)
             {
             Cut (Block, Size);
             }
         else
             {
             Block->SetSize (Size);
             Block->BeFree (false);
             };
         CHECK_ALLOCATOR;
         return (GetBlockData (Block));
         };
     };
return (NULL);
}

LPVOID CAllocator::CoalesceThenAlloc(DWORD Size)
{
ASSERT (Size);
TRACE1 ("Coalescing for %lu bytes ", Size);
DWORD RoundedSize = ROUND_SIZE (Size);
for (CFreeMemBlock* Block = m_Free [BIG_BLOCKS_FREE_LIST];
    Block;
    Block = Block->m_NextFree)
    {
    DWORD BlockSize = Block->GetSize();
    if (Block->IsPreviousFree())
        {
        if (Block->m_PrevFree)
            {
            Block->m_PrevFree->m_NextFree = Block->m_NextFree;
            }
        else
            {
            m_Free [BIG_BLOCKS_FREE_LIST] = Block->m_NextFree;
            };
        if (Block->m_NextFree)
            {
            Block->m_NextFree->m_PrevFree = Block->m_PrevFree;
            };
        do
            {
            Block = Block->GetPrevBlock();
            UnlinkFreeBlock (Block);
            BlockSize += Block->GetSize();
            }
        while (Block->IsPreviousFree());
        ASSERT (IS_ROUNDED (BlockSize));
        for (CMemBlock* NextBlock = (CMemBlock*) &(LPBYTE (Block) [BlockSize]);
            NextBlock->IsFree();
            NextBlock = NextBlock->GetNext())
            {
            UnlinkFreeBlock ((CFreeMemBlock *) NextBlock);
            BlockSize += NextBlock->GetSize();
            };
        Block->SetSize (BlockSize);
        if (Size <= BlockSize)
            {
            if (RoundedSize < BlockSize)
                {
                Cut (Block, Size);
                }
            else
                {
                Block->BeFree (false);
                Block->SetSize (Size);
                };
            TRACE0 ("\n");
            ASSERT (Block->GetSize() == Size);
            return (GetBlockData (Block));
            };
        Block->BlockSizeAtEnd() = BlockSize;
        Block->m_PrevFree = NULL;
        if (Block->m_NextFree = m_Free [BIG_BLOCKS_FREE_LIST])
            {
            m_Free [BIG_BLOCKS_FREE_LIST]->m_PrevFree = Block;
            };
        m_Free [BIG_BLOCKS_FREE_LIST] = Block;
        }
    else
        {
        CMemBlock* NextBlock = Block->GetNext();
        if (NextBlock->IsFree())
            {
            if (Block->m_PrevFree)
                {
                Block->m_PrevFree->m_NextFree = Block->m_NextFree;
                }
            else
                {
                m_Free [BIG_BLOCKS_FREE_LIST] = Block->m_NextFree;
                };
            if (Block->m_NextFree)
                {
                Block->m_NextFree->m_PrevFree = Block->m_PrevFree;
                };
            do
                {
                UnlinkFreeBlock ((CFreeMemBlock *) NextBlock);
                BlockSize += NextBlock->GetSize();
                NextBlock = NextBlock->GetNext();
                }
            while (NextBlock->IsFree());
            Block->SetSize (BlockSize);
            if (Size <= BlockSize)
                {
                if (RoundedSize < BlockSize)
                    {
                    Cut (Block, Size);
                    }
                else
                    {
                    Block->BeFree (false);
                    Block->SetSize (Size);
                    };
                TRACE0 ("\n");
                ASSERT (Block->GetSize() == Size);
                return (GetBlockData (Block));
                };
            Block->BlockSizeAtEnd() = BlockSize;
            Block->m_PrevFree = NULL;
            if (Block->m_NextFree = m_Free [BIG_BLOCKS_FREE_LIST])
                {
                m_Free [BIG_BLOCKS_FREE_LIST]->m_PrevFree = Block;
                };
            m_Free [BIG_BLOCKS_FREE_LIST] = Block;
            };
        };
    TRACE0 (".");
    };
for (int ListIndex = BIG_BLOCKS_FREE_LIST - 1;
     ListIndex >= 0;
     ListIndex--)
    {
    CFreeMemBlock** FreeList = &m_Free [ListIndex];
    for (CFreeMemBlock* Block = (*FreeList);
        Block;
        Block = Block->m_NextFree)
        {
        DWORD BlockSize = Block->GetSize();
        if (Block->IsPreviousFree())
            {
            if (Block->m_PrevFree)
                {
                Block->m_PrevFree->m_NextFree = Block->m_NextFree;
                }
            else
                {
                (*FreeList) = Block->m_NextFree;
                };
            if (Block->m_NextFree)
                {
                Block->m_NextFree->m_PrevFree = Block->m_PrevFree;
                };
            do
                {
                Block = Block->GetPrevBlock();
                UnlinkFreeBlock (Block);
                BlockSize += Block->GetSize();
                }
            while (Block->IsPreviousFree());
            ASSERT (IS_ROUNDED (BlockSize));
            for (CMemBlock* NextBlock = (CMemBlock*) &(LPBYTE (Block) [BlockSize]);
                NextBlock->IsFree();
                NextBlock = NextBlock->GetNext())
                {
                UnlinkFreeBlock ((CFreeMemBlock *) NextBlock);
                BlockSize += NextBlock->GetSize();
                };
            Block->SetSize (BlockSize);
            if (Size <= BlockSize)
                {
                if (RoundedSize < BlockSize)
                    {
                    Cut (Block, Size);
                    }
                else
                    {
                    Block->BeFree (false);
                    Block->SetSize (Size);
                    };
                TRACE0 ("\n");
                ASSERT (Block->GetSize() == Size);
                return (GetBlockData (Block));
                };
            Block->BlockSizeAtEnd() = BlockSize;
            LinkFreeBlock (Block, BlockSize);
            }
        else
            {
            CMemBlock* NextBlock = Block->GetNext();
            if (NextBlock->IsFree())
                {
                if (Block->m_PrevFree)
                    {
                    Block->m_PrevFree->m_NextFree = Block->m_NextFree;
                    }
                else
                    {
                    (*FreeList) = Block->m_NextFree;
                    };
                if (Block->m_NextFree)
                    {
                    Block->m_NextFree->m_PrevFree = Block->m_PrevFree;
                    };
                do
                    {
                    UnlinkFreeBlock ((CFreeMemBlock *) NextBlock);
                    BlockSize += NextBlock->GetSize();
                    NextBlock = NextBlock->GetNext();
                    }
                while (NextBlock->IsFree());
                Block->SetSize (BlockSize);
                if (Size <= BlockSize)
                    {
                    if (RoundedSize < BlockSize)
                        {
                        Cut (Block, Size);
                        }
                    else
                        {
                        Block->BeFree (false);
                        Block->SetSize (Size);
                        };
                    TRACE0 ("\n");
                    ASSERT (Block->GetSize() == Size);
                    return (GetBlockData (Block));
                    };
                Block->BlockSizeAtEnd() = BlockSize;
                LinkFreeBlock (Block, BlockSize);
                };
            };
        TRACE0 (".");
        };
    TRACE1 ("\nList %li", ListIndex);
    };
TRACE0 (" failed\n");
CHECK_ALLOCATOR;
return (NULL);
}

void CAllocator::UnlinkFreeBlock(CFreeMemBlock *Block)
{
ASSERT (Block->IsFree());
ASSERT (IS_ROUNDED (Block->GetSize()));
if (Block->m_PrevFree)
    {
    Block->m_PrevFree->m_NextFree = Block->m_NextFree;
    }
else
    {
    CFreeMemBlock** FreeList = FreeListForSize (Block->GetSize());
    (*FreeList) = Block->m_NextFree;
    };
if (Block->m_NextFree)
    {
    Block->m_NextFree->m_PrevFree = Block->m_PrevFree;
    };
}

bool CAllocator::Check()
{
DWORD BlockSize = GRANULARITY;
for (int Index = 0; Index < FREE_LISTS_COUNT + 1; Index++)
    {
    CFreeMemBlock* Block = m_Free [Index];
    CFreeMemBlock* PrevBlock = NULL;
    for (; Block; 
         PrevBlock = Block, Block = Block->m_NextFree)
        {
        ASSERT (IS_ROUNDED (Block));
        ASSERT (Block->IsFree());
        ASSERT (Block->m_PrevFree == PrevBlock);
        if (Index < BIG_BLOCKS_FREE_LIST)
            {
            ASSERT (Block->GetSize() == BlockSize);
            }
        else
            {
            ASSERT (Block->GetSize() >= BlockSize);
            };
        };
    BlockSize += GRANULARITY;
    };
return (true);
}

LPVOID CAllocator::ReAlloc(LPVOID Data, DWORD NewSize)
{
CMemBlock *Block = GetDataBlock (Data);
ASSERT (IS_ROUNDED (Block));
ASSERT (!Block->IsFree());
DWORD RoundedNewSize = ROUND_SIZE (NewSize + sizeof (DWORD));
DWORD RoundedSize = ROUND_SIZE (Block->GetSize());
if (RoundedNewSize < RoundedSize)
    {
    Block->SetSize (RoundedSize);
    Cut (Block, NewSize + sizeof (DWORD));
    ASSERT (Block->GetSize() == NewSize + sizeof (DWORD));
    CHECK_ALLOCATOR;
    return (Data);
    }
else
    {
    if (RoundedNewSize > RoundedSize)
        {
        LPVOID NewData = Alloc (NewSize, 0);
        MoveMemory (NewData, Data, RoundedSize - sizeof (DWORD));
        Free (Data);
        CHECK_ALLOCATOR;
        ASSERT (GetDataBlock (NewData)->GetSize() == NewSize + sizeof (DWORD));
        return (NewData);
        }
    else
        {
        Block->SetSize (NewSize + sizeof (DWORD));
        ASSERT (Block->GetSize() == NewSize + sizeof (DWORD));
        return (Data);
        };
    };
}

LPVOID CAllocator::GrowThenAlloc(DWORD Size)
{
ASSERT (Size);
DWORD RoundedSize = ROUND_SIZE (Size);
DWORD GrowSize = (RoundedSize + (GROW_STEP - 1)) & ~(GROW_STEP - 1);
ASSERT (IS_ROUNDED (GrowSize));
DWORD NewCommitedSize = m_CommitedSize + GrowSize;
if (NewCommitedSize > m_ReservedSize)
    {
    return (NULL);
    };
CHECK_ALLOCATOR;
VERIFY (::VirtualAlloc (m_Reserved, NewCommitedSize, MEM_COMMIT, PAGE_EXECUTE_READWRITE));
CHECK_ALLOCATOR;
CMemBlock *Block = (CMemBlock*) &(LPBYTE (m_Reserved) [m_CommitedSize - GRANULARITY]);
ASSERT (!Block->IsFree());
ASSERT (Block->GetSize() == 0);
Block->SetSize (Size);
CMemBlock *WorkBlock = Block->GetNext();
if (DWORD FreeBlockSize = (GrowSize - RoundedSize))
    {
    ASSERT (IS_ROUNDED (FreeBlockSize));
    WorkBlock->SetSize (FreeBlockSize);
    WorkBlock->BeFree (true);
    CHECK_ALLOCATOR;
    LinkFreeBlock ((CFreeMemBlock *) WorkBlock, FreeBlockSize);
    CHECK_ALLOCATOR;
    WorkBlock = WorkBlock->GetNext();
    };
ASSERT (LPVOID (WorkBlock) == (LPBYTE) &(LPBYTE (m_Reserved) [NewCommitedSize - GRANULARITY]));
WorkBlock->SetSize (0);
WorkBlock->m_Header &= ~BF_IS_FREE;
TRACE2 ("Grow from %lu to %lu bytes.\n", m_CommitedSize, NewCommitedSize);
m_CommitedSize = NewCommitedSize;
CHECK_ALLOCATOR;
ASSERT (Block->GetSize() == Size);
return (GetBlockData (Block));
}


DWORD CAllocator::GetReservedSize()
{
return (m_ReservedSize);
}

DWORD CAllocator::GetCommitedSize()
{
return (m_CommitedSize);
}

void CAllocator::ForEach(MemBlockEnumFunctionParam *Function, DWORD UserData)
{
for (CMemBlock* CurrentBlock = (CMemBlock*) m_Reserved;
     CurrentBlock; 
     CurrentBlock = CurrentBlock->GetNext())
     {
     if (CurrentBlock->NotFree() && CurrentBlock->GetSize()) // musime testovat i velikost, protoze alokator na konci vzdy vytvari blok nulove delky a ten je treba vynechat
         {
         if (!Function (GetBlockData(CurrentBlock), UserData))
             {
             return;
             };
         };
     };
}

void CAllocator::ForEach(MemBlockEnumFunction *Function)
{
for (CMemBlock* CurrentBlock = (CMemBlock*) m_Reserved;
     CurrentBlock; 
     CurrentBlock = CurrentBlock->GetNext())
     {
     if (CurrentBlock->NotFree() && CurrentBlock->GetSize()) // musime testovat i velikost, protoze alokator na konci vzdy vytvari blok nulove delky a ten je treba vynechat
         {
         if (!Function (GetBlockData(CurrentBlock)))
             {
             return;
             };
         };
     };
}

DWORD CAllocator::GetSize(LPVOID Data)
{
return (GetDataBlock(Data)->GetSize() - sizeof (DWORD));
}



LPVOID CAllocator::GetFirst()
{
if (((CMemBlock*) m_Reserved)->NotFree())
    {
    return (GetBlockData ((CMemBlock *) m_Reserved));
    }
else
    {
    return (GetNext (GetBlockData ((CMemBlock *) m_Reserved)));
    };
}

LPVOID CAllocator::GetNext(LPVOID Previous)
{
for (CMemBlock* CurrentBlock = GetDataBlock(Previous)->GetNext();
     CurrentBlock; 
     CurrentBlock = CurrentBlock->GetNext())
     {
     if (CurrentBlock->NotFree() && CurrentBlock->GetSize()) // musime testovat i velikost, protoze alokator na konci vzdy vytvari blok nulove delky a ten je treba vynechat
         {
         return (GetBlockData(CurrentBlock));
         };
     };
return (NULL);
}
