// Allocator.h: interface for the CAllocator class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ALLOCATOR_H__34BF2CDC_AD9A_43E9_BCA7_B3AD014900F4__INCLUDED_)
#define AFX_ALLOCATOR_H__34BF2CDC_AD9A_43E9_BCA7_B3AD014900F4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define GRANULARITY 16
#define ROUND_SIZE(x) (((x) + GRANULARITY - 1) & ~(GRANULARITY - 1))
#define IS_ROUNDED(x) (((DWORD (x)) & ~(GRANULARITY - 1)) == (DWORD (x)))

#define KILOBYTE 1024
#define MEGABYTE (KILOBYTE * KILOBYTE)
#define GIGABYTE (KILOBYTE * MEGABYTE)


#define INITIAL_RESERVED_SIZE (256 * MEGABYTE)
#define INITIAL_SIZE          (1 * MEGABYTE)
#define GROW_STEP             (128 * KILOBYTE)

#define BF_IS_FREE 0x80000000
#define BF_PREVIOUS_IS_FREE 0x40000000
#define BF_FLAGS_MASK (BF_IS_FREE | BF_PREVIOUS_IS_FREE)
#define BF_SIZE_MASK (~BF_FLAGS_MASK)

#define FREE_LISTS_COUNT 256
#define MAX_SIZE_IN_FREE_LIST (FREE_LISTS_COUNT * GRANULARITY)
#define BIG_BLOCKS_FREE_LIST FREE_LISTS_COUNT

#define CHECK_ALLOCATOR ;
//#define CHECK_ALLOCATOR ASSERT(Check());

#define AF_NO_GROW (0x00000001)

struct CFreeMemBlock;

struct CMemBlock
{
public:
	__forceinline void SetPreviousIsFree(bool IsSuch);
	__forceinline CFreeMemBlock* GetPrevBlock();
	__forceinline bool NotFree();
	__forceinline bool IsFree();
	__forceinline void BeFree (bool BeSuch);
	__forceinline void SetSize (DWORD NewSize);
	__forceinline bool IsPreviousFree();
	__forceinline DWORD& PreviousBlockSizeAtEnd();
	__forceinline DWORD& BlockSizeAtEnd();
	__forceinline DWORD GetSize();
	__forceinline CMemBlock* GetNext();

    DWORD m_Header;
};

struct CFreeMemBlock : public CMemBlock
{
public:
    CFreeMemBlock* m_PrevFree;
    CFreeMemBlock* m_NextFree;
};


typedef bool MemBlockEnumFunction (LPVOID);
typedef bool MemBlockEnumFunctionParam (LPVOID, DWORD);

class CAllocator  
{
public:
	LPVOID GetNext (LPVOID Previous);
	LPVOID GetFirst();
	DWORD GetSize (LPVOID Data);
	// informations
    DWORD GetCommitedSize();
	DWORD GetReservedSize();
    
    // enumeration
	void ForEach (MemBlockEnumFunctionParam *Function, DWORD UserData); // porjde vsechny ALOKOVANE bloky, ne ty prazdne!
	void ForEach (MemBlockEnumFunction *Function); // porjde vsechny ALOKOVANE bloky, ne ty prazdne!
    
    // allocation/deallocation
	LPVOID ReAlloc (LPVOID Data, DWORD NewSize);
	bool Check();
	void Free (LPVOID Data);
	LPVOID Alloc (DWORD Size, DWORD Flags);
    
    CAllocator();
	~CAllocator();

protected:
#ifdef _DEBUG
    LPVOID DoAlloc (DWORD Size, DWORD Flags);
#endif
    
    __forceinline void UnlinkFreeBlock (CFreeMemBlock *Block);
	__forceinline LPVOID GrowThenAlloc (DWORD Size);
	__forceinline LPVOID CoalesceThenAlloc (DWORD Size);
	__forceinline LPVOID AllocFromBigBlocks (DWORD Size);
	__forceinline CFreeMemBlock** FreeListForSize (DWORD BlockSize);
	__forceinline void LinkFreeBlock(CFreeMemBlock *FreeBlock, DWORD BlockSize);
	__forceinline LPVOID GetBlockData (CMemBlock *Block);
	__forceinline CMemBlock* GetDataBlock (LPVOID Data);
	__forceinline void Cut (CMemBlock *CuttedBlock, DWORD Size);
	
    void Destroy();
	void Create();

    CFreeMemBlock* m_Free [FREE_LISTS_COUNT + 1];
    
    CFreeMemBlock* m_Main;
    
    LPVOID         m_Reserved;
    DWORD          m_CommitedSize;
    DWORD          m_ReservedSize;
};

extern CAllocator Allocator;

#endif // !defined(AFX_ALLOCATOR_H__34BF2CDC_AD9A_43E9_BCA7_B3AD014900F4__INCLUDED_)
