// GarbageCollector.cpp: implementation of the CGarbageCollector class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Self.h"

#include "ProtoObject.h"
#include "Allocator.h"
#include "GarbageCollector.h"
#include "PointerObjectMap.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGarbageCollector GarbageCollector;

CGarbageCollector::CGarbageCollector()
{

}

CGarbageCollector::~CGarbageCollector()
{

}

bool CleanMarkFunction (LPVOID Data)
{
((CProtoObject*) Data)->SetGcMark (false);
return (true);
}

void CGarbageCollector::Mark()
{
MarkFrom (CProtoObject::GetFirst());
}

void SetMarkFromRoot(CProtoObject *Root, DWORD UserParam)
{
if (Root->GetGcMark())
    {
    return;
    };
Root->SetGcMark(true);
Root->ForEach (SetMarkFromRoot, NULL);
}

void CGarbageCollector::MarkFrom(CProtoObject *Object)
{
for (CProtoObject *CurrentObject = Object;
     CurrentObject;
     CurrentObject = CurrentObject->GetNext())
     {
     CurrentObject->SetGcMark(false);
     if (CurrentObject->IsRoot())
         {
         MarkFrom (CurrentObject->GetNext());
         SetMarkFromRoot (CurrentObject, NULL);
         break; // to tady musi byt, jinak se to cele posere!
         };
     };
}


void CGarbageCollector::Sweep()
{
/*
Tohle uz neni zapotrebi, protoze mapy od value objektu jsou umisteny ve virtualnim stroji
a mapy od pointerovych objektu maji citac referenci. Dokud na ne ukazuje nejaky objekt, tak
jsou oznaceny jako root.

for (CProtoObject *CurrentObject = CProtoObject::GetFirst(); CurrentObject; CurrentObject = CurrentObject->GetNext())
    {
    if (!CurrentObject->GetGcMark())
        {
        SetMarkFromRoot(CurrentObject->GetMap()->AsProtoObject(), NULL);
        };
    };
*/
for (CProtoObject *CurrentObject = CProtoObject::GetFirst(); CurrentObject;)
    {
    CProtoObject *NextObject = CurrentObject->GetNext();
    if (!CurrentObject->GetGcMark())
        {
        CurrentObject->Delete();
        };
    CurrentObject = NextObject;
    };
}
