// ProtoObject.cpp: implementation of the CProtoObject class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Self.h"
#include "ProtoObject.h"
#include "PointerObjectMap.h"
#include "GarbageCollector.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
//#define new DEBUG_NEW
#endif

void CProtoObject::ForEach(ProtoObjectEnumFunction *Function, DWORD UserParam)
    {
    m_Map->ForEach (this, Function, UserParam);
    }

void CProtoObject::Delete()
    {
    m_Map->Destroy (this);
    m_Map->DecObjectsCounter();
#ifdef _DEBUG    
    m_Map = NULL;
#endif
    Allocator.Free (this);
    }

void CProtoObject::SetMap (CPointerObjectMap *Map)
    {
    if (m_Map)
        {
        m_Map->DecObjectsCounter();
        };
    m_Map = Map;
    if (m_Map)
        {
        m_Map->IncObjectsCounter();
        };
    }

CProtoObject* CProtoObject::New (CPointerObjectMap *Map, DWORD ExtraDataSize)
    {
    CProtoObject* NewObject = (CProtoObject*) Allocator.Alloc(sizeof (CProtoObject) + ExtraDataSize, NULL);
    NewObject->m_Flags = NULL;
    NewObject->m_Map = Map;
    if (Map)
        {
        Map->IncObjectsCounter();
        };
    return (NewObject);
    }
