// ProtoObject.h: interface for the CProtoObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PROTOOBJECT_H__63516F1C_0460_418C_A13F_82B4E17F9363__INCLUDED_)
#define AFX_PROTOOBJECT_H__63516F1C_0460_418C_A13F_82B4E17F9363__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Allocator.h"

class CProtoObject;

typedef void ProtoObjectEnumFunction (CProtoObject*, DWORD);

#define OF_GC_MARK DWORD(0x00000001)
#define OF_GC_ROOT DWORD(0x00000002)

class CPointerObjectMap;

class CProtoObject  
{
public:
	// enumeration
    __forceinline static CProtoObject* GetFirst()
        {
        return ((CProtoObject*) Allocator.GetFirst());
        }

    __forceinline CProtoObject* GetNext ()
        {
        return ((CProtoObject*) Allocator.GetNext(this));
        }

	__forceinline static CProtoObject* FromExtraData (LPVOID ExtraData)
        {
        return ((CProtoObject *) &(LPBYTE (ExtraData) [-(int)sizeof(CProtoObject)]));
        }

    // flags
	__forceinline void BeRoot (bool BeSuch)
        {
        BeSuch ? m_Flags |= OF_GC_ROOT : m_Flags &= ~OF_GC_ROOT;
        }
	__forceinline bool IsRoot()
        {
        return ((m_Flags & OF_GC_ROOT) != 0);
        }
	__forceinline bool GetGcMark()
        {
        return ((m_Flags & OF_GC_MARK) != 0);
        }
	__forceinline void SetGcMark (bool NewValue)
        {
        NewValue ? m_Flags |= OF_GC_MARK : m_Flags &= ~OF_GC_MARK;
        }
    __forceinline DWORD GetFlags()
        {
        return (m_Flags);
        }

    // shortcuts
    void ForEach(ProtoObjectEnumFunction *Function, DWORD UserParam);

	// operations with map
    __forceinline CPointerObjectMap* GetMap()
        {
        return (m_Map);
        }
    
	void SetMap (CPointerObjectMap *Map);

    __forceinline LPVOID GetExtraData()
        {
        return (&(LPBYTE (this) [sizeof (*this)]));
        }

    // creation
    static CProtoObject* New (CPointerObjectMap *Map, DWORD ExtraDataSize);

friend class CGarbageCollector;
protected:
	void Delete();

protected:
    DWORD              m_Flags;
    CPointerObjectMap *m_Map;
};

#endif // !defined(AFX_PROTOOBJECT_H__63516F1C_0460_418C_A13F_82B4E17F9363__INCLUDED_)
