// SelfObject.h: interface for the CSelfObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SELFOBJECT_H__4AEC76E1_9775_4A59_9203_3B434E0DCEA8__INCLUDED_)
#define AFX_SELFOBJECT_H__4AEC76E1_9775_4A59_9203_3B434E0DCEA8__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ProtoObject.h"
#include "VirtualMachine.h"

#define SO_INTEGER_MASK (DWORD (0x00000001))
#define SO_POINTER_MASK (DWORD (0xfffffff7))

class CAbstractMap;

class CSelfObject  
{
public:
    __forceinline CAbstractMap* GetMap()
        {
        if (IsPointer())
            {
            return (((CProtoObject *) m_Data)->GetMap());
            }
        else
            {
            return (NULL); // for now
            };
        };
    
    // converting
    __forceinline CProtoObject* AsProtoObjectDangerously() // no checking for pointer
        {
        return ((CProtoObject*) m_Data);
        };
    
    __forceinline operator CProtoObject*()
        {
        if (IsPointer())
            {
            return (NULL);
            }
        else
            {
            return ((CProtoObject*) m_Data);
            };
        }
    
    // testing
    __forceinline BOOL IsPointer()
        {
        return (!(m_Data & ~SO_POINTER_MASK));
        };

    __forceinline BOOL IsSmallInteger()
        {
        return (m_Data & SO_INTEGER_MASK);
        };

    __forceinline CSelfObject()
        {
        }
    
    __forceinline CSelfObject(LPCTSTR String)
        {
        m_Data = (DWORD) VirtualMachine->NewString(String);
        ASSERT (IsPointer());
        };

    __forceinline CSelfObject(CProtoObject *Object)
        {
        m_Data = (DWORD) Object;
        ASSERT (IsPointer());
        };

protected:
    DWORD m_Data;
};

#endif // !defined(AFX_SELFOBJECT_H__4AEC76E1_9775_4A59_9203_3B434E0DCEA8__INCLUDED_)
