// VMObject.h: interface for the CVMObject class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VMOBJECT_H__52BB250B_200B_4F7F_BF74_6A2967A7EE8B__INCLUDED_)
#define AFX_VMOBJECT_H__52BB250B_200B_4F7F_BF74_6A2967A7EE8B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ProtoObject.h"

class CVMObject
{
public:
	// enumerating members of VMObject
    virtual void ForEach (ProtoObjectEnumFunction *Function, DWORD UserParam) = 0;

    // converting to carrier - CProtoObject
    __forceinline CProtoObject* AsProtoObject()
        {
        return ((CProtoObject*) *this);
        };

// testing
    virtual bool IsMap();
	
    // errors
    void ShouldNotBeCalled();

    // get CProtoObject
    __forceinline operator CProtoObject*()
        {
        return (CProtoObject::FromExtraData (this));
        }

    CVMObject();
    CVMObject(CPointerObjectMap *Map);
	virtual ~CVMObject();

    // debug versions
    void *operator new (size_t Size, LPCTSTR lpszFileName, int nLine);
    void operator delete (void * Object, LPCTSTR lpszFileName, int nLine);
    // ordinal versions
    void *operator new (size_t Size);
    void operator delete (void * Object);
};

#endif // !defined(AFX_VMOBJECT_H__52BB250B_200B_4F7F_BF74_6A2967A7EE8B__INCLUDED_)
