// VirtualMachine.cpp: implementation of the CVirtualMachine class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Self.h"
#include "VirtualMachine.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CVirtualMachine *VirtualMachine = NULL;

CVirtualMachine::CVirtualMachine()
: CVMObject ((CPointerObjectMap *) NULL)
{
AsProtoObject()->BeRoot(true);
m_MapMap = new CMapMap;
m_MapMap->AsProtoObject()->SetMap(m_MapMap);
AsProtoObject()->SetMap (m_MapMap);
}

CVirtualMachine::~CVirtualMachine()
{

}

void CVirtualMachine::Create()
{
if (VirtualMachine)
    {
    throw (_T("Cannot create more the one virtual machines"));
    }
else
    {
    VirtualMachine = new CVirtualMachine;
    VirtualMachine->Initialize();
    };
}

CMapMap* CVirtualMachine::GetMapMap()
{
return (m_MapMap);
}

CByteVectorMap* CVirtualMachine::GetByteVectorMap()
{
return (m_ByteVectorMap);
}

void CVirtualMachine::Initialize()
{
// protoze globalni promenna VirtualMachine je jiz naplnena a mapa MapMap se vytvorila v konstruktoru, muzemem bez obazv vytvaret dalsi mapy
m_ByteVectorMap = new CByteVectorMap;
m_SmallIntegerMap = new CSmallIntegerMap;
}

void CVirtualMachine::ForEach(ProtoObjectEnumFunction *Function, DWORD UserParam)
{
Function (m_MapMap->AsProtoObject(), UserParam);
Function (m_ByteVectorMap->AsProtoObject(), UserParam);
Function (m_SmallIntegerMap->AsProtoObject(), UserParam);
}

CProtoObject* CVirtualMachine::NewString(LPCTSTR String)
{
return (m_ByteVectorMap->NewObject (String));
}
