// VirtualMachine.h: interface for the CVirtualMachine class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIRTUALMACHINE_H__04D58C22_7E6C_4F06_A335_6385A090B9BF__INCLUDED_)
#define AFX_VIRTUALMACHINE_H__04D58C22_7E6C_4F06_A335_6385A090B9BF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "VMObject.h"
#include "MapMap.h"
#include "ByteVectorMap.h"
#include "SmallIntegerMap.h"

class CVirtualMachine : public CVMObject  
{
public:
	CProtoObject* NewString (LPCTSTR String);
	virtual void ForEach(ProtoObjectEnumFunction *Function, DWORD UserParam);

    // maps getters
    CByteVectorMap* GetByteVectorMap();
	CMapMap* GetMapMap();
	
    static void Create();

    CVirtualMachine();
	virtual ~CVirtualMachine();

protected:
	void Initialize();

    CMapMap          *m_MapMap;
    CByteVectorMap   *m_ByteVectorMap;
    CSmallIntegerMap *m_SmallIntegerMap;
};

extern CVirtualMachine* VirtualMachine;

#endif // !defined(AFX_VIRTUALMACHINE_H__04D58C22_7E6C_4F06_A335_6385A090B9BF__INCLUDED_)
